package gui.menus.view;

import java.awt.event.KeyEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

/**
 * @author Serafino
 *
 */

public class ViewMenu extends JMenu {
	
	static final long serialVersionUID = 1l;
	private JMenuItem target;
	private JMenuItem composition;
	private JMenuItem cartesianProduct;
	
	
		public ViewMenu()
		{
			super();
			initialize();
		}
		
		void initialize()
		{
			this.setText("View");
			this.setMnemonic(KeyEvent.VK_E);
			
			/**
			 * adding the target Item
			 */
			target = new TargetViewItem();
			this.add(target);
			/**
			 * adding the composition Item
			 */
			composition = new CompViewItem();
			this.add(composition);
			
			/**
			 * adding the View Cartesian Product Item
			 */
			cartesianProduct = new CartProdItem();
			this.add(cartesianProduct);
		}
		
		public JMenuItem getTargetItem()
		{
			return target;
		}
}
	

